/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.compat.tlm.chatbubble;

import com.github.tartaricacid.netmusic.compat.tlm.client.chatbubble.LyricChatBubbleRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.IChatBubbleRenderer;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.IChatBubbleData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class LyricChatBubbleData
implements IChatBubbleData {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"netmusic", (String)"lyric");
    private static final int PRIORITY = 10;
    private final long songId;
    private final String songName;
    private final int existTick;
    private final long startTick;
    @OnlyIn(value=Dist.CLIENT)
    private IChatBubbleRenderer renderer;

    public LyricChatBubbleData(long songId, String songName, int existTick, long startTick) {
        this.songId = songId;
        this.songName = songName;
        this.existTick = existTick;
        this.startTick = startTick;
    }

    public int existTick() {
        return this.existTick;
    }

    public ResourceLocation id() {
        return ID;
    }

    public long getSongId() {
        return this.songId;
    }

    public String getSongName() {
        return this.songName;
    }

    public long getStartTick() {
        return this.startTick;
    }

    public int priority() {
        return 10;
    }

    @OnlyIn(value=Dist.CLIENT)
    public IChatBubbleRenderer getRenderer(IChatBubbleRenderer.Position position) {
        if (this.renderer == null) {
            this.renderer = new LyricChatBubbleRenderer(this, TYPE_2);
        }
        return this.renderer;
    }

    public static class LyricChatSerializer
    implements IChatBubbleData.ChatSerializer {
        public IChatBubbleData readFromBuff(FriendlyByteBuf buf) {
            return new LyricChatBubbleData(buf.readLong(), buf.readUtf(), buf.readInt(), buf.readLong());
        }

        public void writeToBuff(FriendlyByteBuf buf, IChatBubbleData data) {
            LyricChatBubbleData bubbleData = (LyricChatBubbleData)data;
            buf.writeLong(bubbleData.songId);
            buf.writeUtf(bubbleData.songName);
            buf.writeInt(bubbleData.existTick);
            buf.writeLong(bubbleData.startTick);
        }
    }
}

